/*
 * Decompiled with CFR 0.152.
 */
package com.ludwici.slimeoverhaul.entity.custom.elementals;

import com.ludwici.slimeoverhaul.entity.custom.BaseSlime;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.Tags;

public class AirSlime
extends BaseSlime {
    public boolean doubleJumped = false;

    public AirSlime(EntityType<? extends Slime> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public String getSlimeType() {
        return "air";
    }

    @Override
    public ParticleOptions getParticleType() {
        return ParticleTypes.CLOUD;
    }

    protected float getJumpPower() {
        return this.getJumpPower(1.8f);
    }

    protected void checkFallDamage(double d, boolean bl, BlockState blockState, BlockPos blockPos) {
    }

    @Override
    protected MoveControl initMoveControl() {
        return new AirSlimeMoveControl(this);
    }

    public boolean ignoreExplosion(Explosion explosion) {
        if (explosion.getDirectSourceEntity() instanceof WindCharge) {
            if (!this.hasEffect(MobEffects.LEVITATION)) {
                this.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 100));
            }
            return true;
        }
        return false;
    }

    public boolean isInvulnerableTo(DamageSource source) {
        if (source.getDirectEntity() instanceof WindCharge) {
            return true;
        }
        return super.isInvulnerableTo(source);
    }

    public static boolean checkSpawnRules(EntityType<AirSlime> type, LevelAccessor level, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        if (level.getDifficulty() == Difficulty.PEACEFUL) {
            return false;
        }
        if (level.getLightEngine().getLayerListener(LightLayer.SKY).getLightValue(blockPos) < 8) {
            return false;
        }
        if (level.getBlockState(blockPos.below()).isAir()) {
            return false;
        }
        Holder biome = level.getBiome(blockPos);
        return biome.is(Tags.Biomes.IS_MOUNTAIN_PEAK) ? level.getRandom().nextFloat() <= 0.6f : (biome.is(Tags.Biomes.IS_MOUNTAIN_SLOPE) ? blockPos.getY() >= 140 && level.getRandom().nextFloat() <= 0.35f : blockPos.getY() >= 160 && level.getRandom().nextFloat() <= 0.4f);
    }

    protected static class AirSlimeMoveControl
    extends BaseSlime.SlimeMoveControl<AirSlime> {
        private int nextDoubleJumpTime;

        public AirSlimeMoveControl(AirSlime slime) {
            super(slime);
        }

        @Override
        public void onFall() {
            super.onFall();
            if (((AirSlime)this.slime).hasEffect(MobEffects.LEVITATION)) {
                return;
            }
            if (--this.nextDoubleJumpTime <= 0) {
                ((AirSlime)this.slime).doubleJumped = this.mob.getRandom().nextFloat() >= 0.5f;
                this.nextDoubleJumpTime = ((AirSlime)this.slime).doubleJumped ? this.mob.getRandom().nextInt(100) : this.mob.getRandom().nextInt(20);
            }
            if (((AirSlime)this.slime).doubleJumped) {
                ((AirSlime)this.slime).jumpFromGround();
                ((AirSlime)this.slime).doubleJumped = false;
            }
        }
    }
}

